<?php
	class Payment_model extends CI_Model{
		function __construct(){
			parent:: __construct();
		}
		public function getBillingRef($billRef){
			if($billRef!=null){
				$this->db->where('p_ref_no',$billRef);
			}
			$this->db->where('p_status!=','Deleted');
			$this->db->or_where('p_status','Closed');
			$this->db->order_by('p_id','asc');
			$query=$this->db->get('tbl_payment');
			if($query->result()!=null){
				return $query->result();
			}
			else{
				return null;
			}
		}
		public function check_ref_no($id,$ref_no){
			if($id!=""){
				$this->db->where('p_id!=',$id);
			}
			$this->db->where('p_ref_no',$ref_no);
			$this->db->where('p_status!=','Deleted');
			$query = $this->db->get('tbl_payment');
			if($query->result()!=null){
				return false;
			}else{
				return true;
			}
		}
		public function save(){
			
			//check muna dapat if existing yung ref_no
			if($this->check_ref_no("",$this->input->post('reference_number'))==true){
				$data['p_ref_no'] = $this->input->post('reference_number');
				$data['p_amount'] = $this->input->post('amount');
				$data['p_company'] = $this->input->post('bill_to_company_name');
				$data['p_fname'] = $this->input->post('bill_to_forename'); 
				$data['p_lastname'] = $this->input->post('bill_to_surname');
				$data['p_email'] = $this->input->post('bill_to_email');
				$data['p_address'] = $this->input->post('bill_to_address_line1');
				$data['p_city'] = $this->input->post('bill_to_address_city');
				$data['p_state'] = $this->input->post('bill_to_address_state');
				$data['p_postal_code'] = $this->input->post('bill_to_address_postal_code');
				$data['p_country'] = $this->input->post('bill_to_address_country');
				$data['p_remarks'] = $this->input->post('bill_to_remarks');
				$data['p_remarks_text'] = $this->input->post('bill_to_remarks_text');
				$data['p_purpose'] = $this->input->post('bill_to_Purpose');
				$data['p_purpose_text'] = $this->input->post('bill_to_Purpose_text');
				$data['p_status']="Active";
				$data['p_expiration_date'] = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'). ' + 5 minute'));
				$data['p_add_logs'] = date('Y-m-d H:i:s'); 
				if($this->db->insert('tbl_payment',$data)){
					$last_id = $this->db->insert_id();
					$encrypted_txt1 = $this->encrypt_decrypt('encrypt', $last_id);
					$encrypted_txt2 = $this->encrypt_decrypt('encrypt', $this->input->post('reference_number'));
					echo "salt1=".$encrypted_txt1."&salt2=".$encrypted_txt2;
				}else{
					echo "Error";
				} 
			}else{
				echo "Exist";
			}
			
			
		}
		public function check($salt1,$salt2){
			$response = array();
			$p_id = $this->encrypt_decrypt('decrypt',$salt1); 
			$ref_no = $this->encrypt_decrypt('decrypt',$salt2); 
			$this->db->where('p_id',$p_id);
			$this->db->where('p_ref_no',$ref_no);
			$this->db->where('p_status','Active');
			$query = $this->db->get('tbl_payment');
			
			if($query->result()!=null){
				$response["message"] = ''; 
				$response["data"] ='';
				$response["success"] = 0;
				foreach($query->result() as $r){
					if($r->p_status=="Active" and $r->p_expiration_date>date('Y-m-d H:i:s')){
						$response["data"] = $query->result();
						$response["success"] = 1;
						$response["message"] = 'okay'; 
					}else if($r->p_status=="Active" and $r->p_expiration_date<date('Y-m-d H:i:s')){
						$response["success"] = 0;
						$response["message"] = "Expired, Please contact your sales representative";
						$this->change_payment_status($r->p_ref_no,"Expired");
					}else{
						$response["success"] = 0;
						$response["message"] = "Invalid URL";
					}
				}
				echo json_encode($response);
			}else{ 
				$response["success"] = 0;
				$response["message"] = "Invalid URL";
				echo json_encode($response);
			}	
			
			
		} 
		public function gen_link($id,$ref_no){  
			$encrypted_txt1 = $this->encrypt_decrypt('encrypt', $id);
			$encrypted_txt2 = $this->encrypt_decrypt('encrypt', $ref_no);
			echo "salt1=".$encrypted_txt1."&salt2=".$encrypted_txt2;
		}
		public function open_link($id,$ref_no){
			$this->db->where('p_id',$id);
			$this->db->where('p_ref_no',$ref_no);
			$data['p_status'] = 'Active';
			$data['p_expiration_date'] = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'). ' + 5 minute'));
			if($this->db->update('tbl_payment',$data)){
				$encrypted_txt1 = $this->encrypt_decrypt('encrypt', $id);
				$encrypted_txt2 = $this->encrypt_decrypt('encrypt', $ref_no);
				echo "salt1=".$encrypted_txt1."&salt2=".$encrypted_txt2;
			}else{
				echo "Error";
			}
			
			
		}
		
		public function close_link($id,$ref_no){
			$this->db->where('p_id',$id);
			$this->db->where('p_ref_no',$ref_no);
			$data['p_status'] = 'Closed';
			if($this->db->update('tbl_payment',$data)){
				$encrypted_txt1 = $this->encrypt_decrypt('encrypt', $id);
				$encrypted_txt2 = $this->encrypt_decrypt('encrypt', $ref_no);
				echo "salt1=".$encrypted_txt1."&salt2=".$encrypted_txt2;
			}else{
				echo "Error";
			}
			
			
		}
		public function encrypt_decrypt($action, $string) {
			$output = false;
			$encrypt_method = "AES-256-CBC";
			$secret_key = 'KGSADMIN2019';
			$secret_iv = 'kgsadmin@)!(';
			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);
			if ( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
			} else if( $action == 'decrypt' ) {
				$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
			}
			return $output;
		}
		
		public function update_link($salt1,$salt2){
			$dencrypted_txt1 = $this->encrypt_decrypt('decrypt', $salt1);
			$dencrypted_txt2 = $this->encrypt_decrypt('decrypt', $salt2);
			$this->db->where('p_id',$dencrypted_txt1);
			$this->db->where('p_ref_no',$dencrypted_txt2);
			$data['p_status']='Closed';
			if($this->db->update('tbl_payment',$data)){
				
			}else{
				return "Error";
			}
			
		}
		public function change_payment_status($ref,$status){
			$this->db->where('p_ref_no',$ref);
			$data['p_status']=$status;
			if($this->db->update('tbl_payment',$data)){
				
			}
		}
		public function check_all_active_payment(){
			$data['p_status']='Active';
			$query = $this->db->get('tbl_payment');
			if($query->result()!=null){
				foreach($query->result() as $r){
					if($r->p_status=="Active" and $r->p_expiration_date<date('Y-m-d H:i:s')){
						$this->change_payment_status($r->p_ref_no,"Expired");
					}
				}
			}
		}
		public function fetch_data($id,$ref_no){
			$this->db->where('p_id',$id);
			$query = $this->db->get('tbl_payment');
			if($query->result()!=null){
				return $query->result();
			}else{
				
				return "Error";
			}
		}
		public function save_edit(){
			if($this->check_ref_no($this->input->post('p_id'),$this->input->post('reference_number'))==true){
				$data['p_ref_no'] = $this->input->post('reference_number');
				$data['p_amount'] = $this->input->post('amount');
				$data['p_company'] = $this->input->post('bill_to_company_name');
				$data['p_fname'] = $this->input->post('bill_to_forename'); 
				$data['p_lastname'] = $this->input->post('bill_to_surname');
				$data['p_email'] = $this->input->post('bill_to_email');
				$data['p_address'] = $this->input->post('bill_to_address_line1');
				$data['p_city'] = $this->input->post('bill_to_address_city');
				$data['p_state'] = $this->input->post('bill_to_address_state');
				$data['p_postal_code'] = $this->input->post('bill_to_address_postal_code');
				$data['p_country'] = $this->input->post('bill_to_address_country');
				$data['p_remarks'] = $this->input->post('bill_to_remarks');
				$data['p_remarks_text'] = $this->input->post('bill_to_remarks_text');
				$data['p_purpose'] = $this->input->post('bill_to_Purpose');
				$data['p_purpose_text'] = $this->input->post('bill_to_purpose_text');
				$data['p_status']="Active";
				$data['p_expiration_date'] = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'). ' + 5 minute'));
				$data['p_edit_logs'] = date('Y-m-d H:i:s'); 
				$this->db->where("p_id",$this->input->post('p_id'));
				if($this->db->update('tbl_payment',$data)){
					$last_id = $this->db->insert_id();
					$encrypted_txt1 = $this->encrypt_decrypt('encrypt', $last_id);
					$encrypted_txt2 = $this->encrypt_decrypt('encrypt', $this->input->post('reference_number'));
					echo "salt1=".$encrypted_txt1."&salt2=".$encrypted_txt2;
				}else{
					echo "Error";
				} 
			}else{
				echo "Exist";
			}
		}
		
		public function check_expired(){
			$this->db->where("p_status","Active");
			$query = $this->db->get("tbl_payment");
			if($query->result()!=null){
				foreach($query->result() as $p){
					if($p->p_expiration_date<date('Y-m-d H:i:s')){
						$this->change_payment_status($p->p_ref_no,"Expired");
					}	
				}
			}
		}
		public function updatepayment($salt1,$salt2){
			$ref_no = "";
			$amount = "";
			list($salt1, $enc_iv) = explode("::", $salt1);;
			list($salt2, $enc_iv) = explode("::", $salt2);;
			$cipher_method = 'aes-128-ctr';
			$enc_key = openssl_digest(php_uname(), 'SHA256', TRUE);
			$ref_no = openssl_decrypt($salt1, $cipher_method, $enc_key, 0, hex2bin($enc_iv));
			$amount = openssl_decrypt($salt2, $cipher_method, $enc_key, 0, hex2bin($enc_iv));
			unset($salt1, $cipher_method, $enc_key, $enc_iv);
			unset($salt2, $cipher_method, $enc_key, $enc_iv);
			$ref_no = substr($ref_no, 4);
			$this->db->where('p_ref_no',$ref_no);
			$this->db->where('p_status','active');
			$query = $this->db->get("tbl_payment");
			if($query->result()!=null){
				foreach($query->result() as $p){
					if($p->p_amount==$amount){
						$this->change_payment_status($p->p_ref_no,"Success");
					}	
				}
			}
			
		}
	}
?>