let theWheel = new Winwheel({
	'numSegments'  : 14,     // Specify number of segments.
	'outerRadius'  : 312,   // Set outer radius so wheel fits inside the background.
	'textFontSize' : 28,    // Set font size as desired.
	'segments'     :        // Define segments including colour and text.
	[
	   {'fillStyle' : '#51ADE7', 'text' : 'MUG'},
	   {'fillStyle' : '#5176E7', 'text' : 'PEN'},
	   {'fillStyle' : '#7751E7', 'text' : 'BALLER'},
	   {'fillStyle' : '#9600FF', 'text' : 'ECO-BAG'},
	   {'fillStyle' : '#CF00FF', 'text' : 'KEYCHAIN'},
	   {'fillStyle' : '#FF008E', 'text' : 'NOTEBOOK'},
	   {'fillStyle' : '#FF4646', 'text' : 'SNACKS'},
	   {'fillStyle' : '#FF8000', 'text' : 'MUG'},
	   {'fillStyle' : '#E6B006', 'text' : 'PEN'},
	   {'fillStyle' : '#B7E606', 'text' : 'BALLER'},
	   {'fillStyle' : '#9EE606', 'text' : 'ECO-BAG'},
	   {'fillStyle' : '#71E751', 'text' : 'KEYCHAIN'},
	   {'fillStyle' : '#51E797', 'text' : 'NOTEBOOK'},
	   {'fillStyle' : '#51E7D7', 'text' : 'SNACKS'}
	],
	'animation' :           // Specify the animation to use.
	{
		'type'     : 'spinToStop',
		'duration' : Math.random() * 10 + 10,
		'spins'    : 8,
		'callbackFinished' : alertPrize,
		'callbackSound'    : playSound,   // Function to call when the tick sound is to be triggered.
		'soundTrigger'     : 'pin'        // Specify pins are to trigger the sound, the other option is 'segment'.
	},
	'pins' :
	{
		'number' : 28   // Number of pins. They space evenly around the wheel.
	}
});

// -----------------------------------------------------------------
// This function is called when the segment under the prize pointer changes
// we can play a small tick sound here like you would expect on real prizewheels.
// -----------------------------------------------------------------
let audio = new Audio('tick.mp3');  // Create audio object and load tick.mp3 file.

function playSound()
{
	// Stop and rewind the sound if it already happens to be playing.
	audio.pause();
	audio.currentTime = 0;
	// Play the sound.
	audio.play();
}
// -------------------------------------------------------
// Called when the spin animation has finished by the callback feature of the wheel because I specified callback in the parameters
// note the indicated segment is passed in as a parmeter as 99% of the time you will want to know this to inform the user of their prize.
// -------------------------------------------------------
function alertPrize(indicatedSegment)
{
	// Do basic alert of the segment text.
	// You would probably want to do something more interesting with this information.
	//alert("You have won " + indicatedSegment.text);
	if(indicatedSegment.text=="MUG"){
		$("#mug_price").css("display","block");
		$("#mug_price_modal").css("display","block");
	}else if(indicatedSegment.text=="PEN"){
		$("#pen_price").css("display","block");
		$("#pen_price_modal").css("display","block");
	}else if(indicatedSegment.text=="BALLER"){
		$("#baller_price").css("display","block");
		$("#baller_price_modal").css("display","block");
	}else if(indicatedSegment.text=="ECO-BAG"){
		$("#ecobag_price").css("display","block");
		$("#ecobag_price_modal").css("display","block");
	}else if(indicatedSegment.text=="KEYCHAIN"){
		$("#keychain_price").css("display","block");
		$("#keychain_price_modal").css("display","block");
	}else if(indicatedSegment.text=="NOTEBOOK"){
		$("#notebook_price").css("display","block");
		$("#notebook_price_modal").css("display","block");
	}else if(indicatedSegment.text=="SNACKS"){
		$("#snacks_price").css("display","block");
		$("#snacks_price_modal").css("display","block");
	}else{
		$("#again_price").css("display","block");
		$("#again_price_modal").css("display","block");
	}	
	startConfetti();
}

// =======================================================================================================================
// Code below for the power controls etc which is entirely optional. You can spin the wheel simply by
// calling theWheel.startAnimation();
// =======================================================================================================================
let wheelPower    = 0;
let wheelSpinning = false;

// -------------------------------------------------------
// Function to handle the onClick on the power buttons.
// -------------------------------------------------------

// -------------------------------------------------------
// Click handler for spin button.
// -------------------------------------------------------
function startSpin()
{
	//alert('test');

	// Ensure that spinning can't be clicked again while already running.
	if (wheelSpinning == false) {
		
		theWheel.startAnimation();
		
		wheelSpinning = true;
	}
	

}

// -------------------------------------------------------
// Function for reset button.
// -------------------------------------------------------
function resetWheel()
{
	theWheel.stopAnimation(false);  // Stop the animation, false as param so does not call callback function.
	theWheel.rotationAngle = 0;     // Re-set the wheel angle to 0 degrees.
	theWheel.draw();                // Call draw to render changes to the wheel.

	document.getElementById('pw1').className = "";  // Remove all colours from the power level indicators.
	document.getElementById('pw2').className = "";
	document.getElementById('pw3').className = "";

	wheelSpinning = false;          // Reset to false to power buttons and spin can be clicked again.
}
function close_modal(data){
	// alert(data);
  if(data=="MUG"){
	$("#mug_price").css("display","none");
	$("#mug_price_modal").css("display","none");
	wheelSpinning = false;
  }else if(data=="PEN"){
	$("#pen_price").css("display","none");
	$("#pen_price_modal").css("display","none");
	wheelSpinning = false;
  }else if(data=="BALLER"){
	$("#baller_price").css("display","none");
	$("#baller_price_modal").css("display","none");
	wheelSpinning = false;
  }	else if(data=="ECO-BAG"){
	$("#ecobag_price").css("display","none");
	$("#ecobag_price_modal").css("display","none");
	wheelSpinning = false;
  }	else if(data=="KEYCHAIN"){
	$("#keychain_price").css("display","none");
	$("#keychain_price_modal").css("display","none");
	wheelSpinning = false;
  }	else if(data=="NOTEBOOK"){
	$("#notebook_price").css("display","none");
	$("#notebook_price_modal").css("display","none");
	wheelSpinning = false;
  }	else if(data=="SNACKS"){
	$("#snacks_price").css("display","none");
	$("#snacks_price_modal").css("display","none");
	wheelSpinning = false;
  }	else{
	$("#again_price").css("display","none");
	$("#again_price_modal").css("display","none");
	wheelSpinning = false;
  }	
}
/*

var options = ["MUG","PEN","BALLER","ECO-BAG","KEYCHAIN","NOTEBOOK","SNACKS","MUG","PEN","BALLER","ECO-BAG","KEYCHAIN","NOTEBOOK","SNACKS"];

var startAngle = 0;
var arc = Math.PI / (options.length / 2);
var spinTimeout = null;

var spinArcStart = 10;
var spinTime = 0; 
var spinTimeTotal = 0;

var ctx;

document.getElementById("startSpin").addEventListener("click", startSpin);

function byte2Hex(n) {
  var nybHexString = "0123456789ABCDEF";
  return String(nybHexString.substr((n >> 4) & 0x0F,1)) + nybHexString.substr(n & 0x0F,1);
}

function RGB2Color(r,g,b) {
	return '#' + byte2Hex(r) + byte2Hex(g) + byte2Hex(b);
}

function getColor(item, maxitem) {
  var phase = 0; 
  var center = 128;
  var width = 127;
  var frequency = Math.PI*2/maxitem;
  
  red   = Math.sin(frequency*item+2+phase) * width + center;
  green = Math.sin(frequency*item+0+phase) * width + center;
  blue  = Math.sin(frequency*item+4+phase) * width + center;
  
  return RGB2Color(red,green,blue);
}

function drawRouletteWheel() {
  var canvas = document.getElementById("canvas");
  if (canvas.getContext) { 
    var outsideRadius = 300;
    var textRadius = 200;
    var insideRadius = 50;

    ctx = canvas.getContext("2d"); 
    ctx.clearRect(0,0,500,500);

    ctx.strokeStyle = "black";
    ctx.lineWidth = 10;
 
    ctx.font = 'bold 30px Helvetica, Arial';

    for(var i = 0; i < options.length; i++) {
      var angle = startAngle + i * arc;
      //ctx.fillStyle = colors[i];
      ctx.fillStyle = getColor(i, options.length);

      ctx.beginPath();
      ctx.arc(310, 310, outsideRadius, angle, angle + arc, false);
      ctx.arc(310, 310, insideRadius, angle + arc, angle, true);
      ctx.stroke();
      ctx.fill();

      ctx.save();
      ctx.shadowOffsetX = -1;
      ctx.shadowOffsetY = -1;
      ctx.shadowBlur    = 0;
      ctx.shadowColor   = "rgb(0,0,0)";
      ctx.fillStyle = "white";
      ctx.translate(310 + Math.cos(angle + arc / 2) * textRadius, 
                    310 + Math.sin(angle + arc / 2) * textRadius);
      ctx.rotate(angle + arc / 30 + Math.PI / 30);
      var text = options[i];
      ctx.fillText(text, -ctx.measureText(text).width / 2, 0);
      ctx.restore();
    } 

    //Arrow
    ctx.fillStyle = "black";
    ctx.beginPath();
    ctx.moveTo(310 - 14, 310 - (outsideRadius + 15));
    ctx.lineTo(310 + 14, 310 - (outsideRadius + 15));
    ctx.lineTo(310 + 14, 310 - (outsideRadius - 15));
    ctx.lineTo(310 + 19, 310 - (outsideRadius - 15));
    ctx.lineTo(310 + 0, 310 - (outsideRadius - 30));
    ctx.lineTo(310 - 19, 310 - (outsideRadius - 15));
    ctx.lineTo(310 - 14, 310 - (outsideRadius - 15));
    ctx.lineTo(310 - 14, 310 - (outsideRadius + 15));
    ctx.fill();
  }
}

function spin() {
  spinAngleStart = Math.random() * 10 + 10;
  // spinAngleStart =20;
  spinTime = 0;
  // spinTimeTotal = Math.random() * 3 + 4 * 1000;
  spinTimeTotal = 5000;
  // console.log(spinTimeTotal);
  rotateWheel();
}

function rotateWheel() {
  spinTime += 20;
  if(spinTime >= spinTimeTotal) {
    stopRotateWheel();
    return;
  }
  var spinAngle = spinAngleStart - easeOut(spinTime, 0, spinAngleStart, spinTimeTotal);
  startAngle += (spinAngle * Math.PI / 180);
  drawRouletteWheel();
  spinTimeout = setTimeout('rotateWheel()', 20);
}

function stopRotateWheel() {
  clearTimeout(spinTimeout);
  var degrees = startAngle * 180 / Math.PI + 90;
  var arcd = arc * 180 / Math.PI;
  var index = Math.floor((360 - degrees % 360) / arcd);
  ctx.save();
  ctx.font = 'bold 30px Helvetica, Arial';
  var text = options[index]
  // ctx.fillText(text, 250 - ctx.measureText(text).width / 2, 250 + 10);
  ctx.restore();
  
  if(text=="MUG"){
	$("#mug_price").css("display","block");
	$("#mug_price_modal").css("display","block");
  }else if(text=="PEN"){
	$("#pen_price").css("display","block");
	$("#pen_price_modal").css("display","block");
  }else if(text=="BALLER"){
	$("#baller_price").css("display","block");
	$("#baller_price_modal").css("display","block");
  }	else if(text=="ECO-BAG"){
	$("#ecobag_price").css("display","block");
	$("#ecobag_price_modal").css("display","block");
  }	else if(text=="KEYCHAIN"){
	$("#keychain_price").css("display","block");
	$("#keychain_price_modal").css("display","block");
  }	else if(text=="NOTEBOOK"){
	$("#notebook_price").css("display","block");
	$("#notebook_price_modal").css("display","block");
  }	else if(text=="SNACKS"){
	$("#snacks_price").css("display","block");
	$("#snacks_price_modal").css("display","block");
  }	else{
	$("#again_price").css("display","block");
	$("#again_price_modal").css("display","block");
  }	
  startConfetti();
 

 // alert(text);
//popupwin
    
}

function easeOut(t, b, c, d) {
  var ts = (t/=d)*t;
  var tc = ts*t;
  return b+c*(tc + -3*ts + 3*t);
}

drawRouletteWheel();

function close_modal(data){
	// alert(data);
  if(data=="MUG"){
	$("#mug_price").css("display","none");
	$("#mug_price_modal").css("display","none");
  }else if(data=="PEN"){
	$("#pen_price").css("display","none");
	$("#pen_price_modal").css("display","none");
  }else if(data=="BALLER"){
	$("#baller_price").css("display","none");
	$("#baller_price_modal").css("display","none");
  }	else if(data=="ECO-BAG"){
	$("#ecobag_price").css("display","none");
	$("#ecobag_price_modal").css("display","none");
  }	else if(data=="KEYCHAIN"){
	$("#keychain_price").css("display","none");
	$("#keychain_price_modal").css("display","none");
  }	else if(data=="NOTEBOOK"){
	$("#notebook_price").css("display","none");
	$("#notebook_price_modal").css("display","none");
  }	else if(data=="SNACKS"){
	$("#snacks_price").css("display","none");
	$("#snacks_price_modal").css("display","none");
  }	else{
	$("#again_price").css("display","none");
	$("#again_price_modal").css("display","none");
  }	
}
*/