CREATE DATABASE  IF NOT EXISTS `kelinphc_monitoring` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `kelinphc_monitoring`;
-- MySQL dump 10.13  Distrib 5.6.13, for Win32 (x86)
--
-- Host: localhost    Database: kelinphc_monitoring
-- ------------------------------------------------------
-- Server version	5.6.17

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `tbl_account`
--

DROP TABLE IF EXISTS `tbl_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_account` (
  `acc_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_username` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_password` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_fname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_lname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_mname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_email` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_gender` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_bday` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_cnum` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_branch` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_logs` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`acc_id`),
  KEY `indx_acc_br_id` (`acc_branch`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_account`
--

LOCK TABLES `tbl_account` WRITE;
/*!40000 ALTER TABLE `tbl_account` DISABLE KEYS */;
INSERT INTO `tbl_account` VALUES (1,'admin','admin123','Main','Branch','','main@kelinph.com','Male','','','1','Active',NULL),(2,'manila','manila123','Manila','Branch','','manila@kelinph.com','Female',NULL,NULL,'2','Active',NULL),(3,'davao','davao123','Davao','Branch','','davao@kelinph.com','Male',NULL,NULL,'10','Active',NULL),(4,'cebu','cebu123','Cebu','Branch',NULL,'cebu@kelinph.com','Male',NULL,NULL,'4','Active',NULL),(5,'tacloban','tacloban123','Tacloban','Branch',NULL,'tacloban@kelinph.com','Male',NULL,NULL,'5','Active',NULL),(6,'iloilo','iloilo123','ILOILO','Branch','','iloilo@kelinph.com','Male',NULL,NULL,'6','Active',NULL),(7,'cdo','cdo123','CDO','Branch',NULL,'cdo@kelinph.com','Male',NULL,NULL,'8','Active',NULL),(8,'naga','naga123','Naga','Branch','','naga@kelinph.com','Female','','','3','Active',NULL),(9,'zamboanga','zamboanga123','Zamboanga','Bracnh',NULL,'zamboanga@kelinph.com','Male',NULL,NULL,'9','Active',NULL),(10,'bacolod','bacolod123','Bacolod','Branch',NULL,'bacolod@kelinph.com','Male',NULL,NULL,'7','Active',NULL);
/*!40000 ALTER TABLE `tbl_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_branch`
--

DROP TABLE IF EXISTS `tbl_branch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_branch` (
  `br_id` int(11) NOT NULL AUTO_INCREMENT,
  `br_name` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_addr` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_cnum` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`br_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_branch`
--

LOCK TABLES `tbl_branch` WRITE;
/*!40000 ALTER TABLE `tbl_branch` DISABLE KEYS */;
INSERT INTO `tbl_branch` VALUES (1,'Main',NULL,NULL,'Active'),(3,'Naga',NULL,NULL,'Active'),(4,'Cebu',NULL,NULL,'Active'),(5,'Tacloban',NULL,NULL,'Active'),(6,'Iloilo',NULL,NULL,'Active'),(7,'Bacolod',NULL,NULL,'Active'),(8,'CDO',NULL,NULL,'Active'),(9,'Zamboanga',NULL,NULL,'Active'),(10,'Davao',NULL,NULL,'Active'),(2,'Manila',NULL,NULL,'Active');
/*!40000 ALTER TABLE `tbl_branch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_client`
--

DROP TABLE IF EXISTS `tbl_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_client` (
  `c_id` int(11) NOT NULL AUTO_INCREMENT,
  `c_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_address` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_tin` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_contact_person` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_contact_number` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_branch` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_type` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_logs` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_client`
--

LOCK TABLES `tbl_client` WRITE;
/*!40000 ALTER TABLE `tbl_client` DISABLE KEYS */;
INSERT INTO `tbl_client` VALUES (1,'Mn-Supplier one','Mn-address one','Mn-tin one','Mn-Contact Person one','Mn-Contact Number One','1','Supplier','Active','UB: Main Branch 2019-12-19 17:18:34'),(2,'Mnl-Supplier one','Mnl-address one','Mnl-tin one','Mnl-Contact Person one','Mnl-Contact Number One','2','Supplier','Active','UB: Main Branch 2019-12-19 17:19:32'),(3,'Customer One','Address One','Tin One','Contact Person one','Contact Number One','2','Customer','Active','UB: Main Branch 2019-12-19 16:59:00'),(4,'Mnl-Supplier Two','Mnl-Address Two','Mnl-Tin Two','Mnl-Contact Person Two','Mnl-Contact Number Two','2','Supplier','Active','UB: Main Branch 2019-12-19 17:20:07'),(5,'1','1','1','1','1','2','Supplier','Deleted',NULL),(6,'Mn-Supplier Two','Mn-Address Two','Mn-Tin Two','Mn-Contact Person Two','Mn-Contact Number Two','1','Supplier','Active','UB: Main Branch 2019-12-19 17:21:07'),(7,'Mnl-Supplier Three','Mnl-Address  Three','Mnl-Tin  Three','Mnl-Contact Person  Three','Mnl-Contact Number  Three','2','Supplier','Active','UB: Main Branch 2019-12-19 17:21:31'),(8,'Customer One','-','-','-','-','1','Customer','Active','CB: Main Branch 2019-12-21 16:33:22'),(9,'Customer two','-','-','-','-','1','Customer','Active','CB: Main Branch 2019-12-21 17:14:34');
/*!40000 ALTER TABLE `tbl_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `tbl_client_view`
--

DROP TABLE IF EXISTS `tbl_client_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_client_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_client_view` (
  `c_id` tinyint NOT NULL,
  `c_name` tinyint NOT NULL,
  `c_address` tinyint NOT NULL,
  `c_tin` tinyint NOT NULL,
  `c_contact_person` tinyint NOT NULL,
  `c_contact_number` tinyint NOT NULL,
  `c_branch` tinyint NOT NULL,
  `c_type` tinyint NOT NULL,
  `c_status` tinyint NOT NULL,
  `c_logs` tinyint NOT NULL,
  `br_id` tinyint NOT NULL,
  `br_name` tinyint NOT NULL,
  `br_addr` tinyint NOT NULL,
  `br_cnum` tinyint NOT NULL,
  `br_status` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tbl_product`
--

DROP TABLE IF EXISTS `tbl_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_product` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_code` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `p_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `p_category` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `p_quantity` double DEFAULT '0',
  `p_cost` double DEFAULT '0',
  `p_price` double DEFAULT '0',
  `p_unit` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `p_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `p_logs` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`p_id`),
  KEY `index_p_code` (`p_code`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_product`
--

LOCK TABLES `tbl_product` WRITE;
/*!40000 ALTER TABLE `tbl_product` DISABLE KEYS */;
INSERT INTO `tbl_product` VALUES (1,'000001','Product One','',0,1,2,NULL,'Active',NULL),(2,'000002','Product Two','',0,5,7,NULL,'Active',NULL),(3,'000003','Product three','',0,100,120,NULL,'Active',NULL),(4,'000004','Product Four','',0,10,25,NULL,'Active','UB: Main Branch 2019-12-19 17:15:55'),(5,'000005','Product Five','',0,1000,1200,NULL,'Active','CB: Main Branch 2019-12-19 17:15:17');
/*!40000 ALTER TABLE `tbl_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `tbl_product_view`
--

DROP TABLE IF EXISTS `tbl_product_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_product_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_product_view` (
  `p_id` tinyint NOT NULL,
  `p_code` tinyint NOT NULL,
  `p_name` tinyint NOT NULL,
  `p_category` tinyint NOT NULL,
  `p_quantity` tinyint NOT NULL,
  `p_cost` tinyint NOT NULL,
  `p_price` tinyint NOT NULL,
  `p_unit` tinyint NOT NULL,
  `p_status` tinyint NOT NULL,
  `p_logs` tinyint NOT NULL,
  `po` tinyint NOT NULL,
  `si` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tbl_purchaseorder`
--

DROP TABLE IF EXISTS `tbl_purchaseorder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_purchaseorder` (
  `po_id` int(11) NOT NULL AUTO_INCREMENT,
  `po_branch` varchar(45) NOT NULL,
  `po_ref_no` varchar(45) NOT NULL,
  `po_c_id` varchar(45) DEFAULT NULL,
  `po_date` varchar(45) DEFAULT NULL,
  `po_time` varchar(45) DEFAULT NULL,
  `po_remarks` varchar(45) DEFAULT NULL,
  `po_status` varchar(45) DEFAULT NULL,
  `po_log` text,
  PRIMARY KEY (`po_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_purchaseorder`
--

LOCK TABLES `tbl_purchaseorder` WRITE;
/*!40000 ALTER TABLE `tbl_purchaseorder` DISABLE KEYS */;
INSERT INTO `tbl_purchaseorder` VALUES (1,'1','10000000','1','2019-12-05','15:08:52','test','Active',''),(3,'1','10000002','6','2019-12-20','15:35:12','','Active',''),(4,'1','10000003','1','2019-12-21','17:34:27',NULL,'Active','Added by: Main Branch-2019-12-21 17:34:27');
/*!40000 ALTER TABLE `tbl_purchaseorder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_purchaseorder_item`
--

DROP TABLE IF EXISTS `tbl_purchaseorder_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_purchaseorder_item` (
  `poi_id` int(11) NOT NULL AUTO_INCREMENT,
  `poi_ref_no` varchar(45) DEFAULT NULL,
  `poi_p_id` varchar(45) DEFAULT NULL,
  `poi_qty` varchar(45) DEFAULT NULL,
  `poi_cost` varchar(45) DEFAULT NULL,
  `poi_status` varchar(45) DEFAULT NULL,
  `poi_log` text,
  PRIMARY KEY (`poi_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_purchaseorder_item`
--

LOCK TABLES `tbl_purchaseorder_item` WRITE;
/*!40000 ALTER TABLE `tbl_purchaseorder_item` DISABLE KEYS */;
INSERT INTO `tbl_purchaseorder_item` VALUES (1,'10000000','000005','50','5','Active','Added by: Main Branch-2019-12-20 15:08:52/ Up'),(2,'10000002','000001','100','1','Active',''),(3,'10000002','000002','150','5','Active','/ Updated by Main Branch 2019-12-21 17:05:21'),(4,'10000002','000003','200','100','Active','/ Updated by Main Branch 2019-12-21 17:05:14'),(5,'10000002','000004','100','100','Deleted','/ Deleted by Main Branch 2019-12-21 16:57:28'),(6,'10000003','000001','20','1','Active','Added by: Main Branch-2019-12-21 17:34:27');
/*!40000 ALTER TABLE `tbl_purchaseorder_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `tbl_purchaseorder_item_view`
--

DROP TABLE IF EXISTS `tbl_purchaseorder_item_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_purchaseorder_item_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_purchaseorder_item_view` (
  `poi_id` tinyint NOT NULL,
  `poi_ref_no` tinyint NOT NULL,
  `poi_p_id` tinyint NOT NULL,
  `poi_qty` tinyint NOT NULL,
  `poi_cost` tinyint NOT NULL,
  `poi_status` tinyint NOT NULL,
  `poi_log` tinyint NOT NULL,
  `p_id` tinyint NOT NULL,
  `p_code` tinyint NOT NULL,
  `p_name` tinyint NOT NULL,
  `p_category` tinyint NOT NULL,
  `p_quantity` tinyint NOT NULL,
  `p_cost` tinyint NOT NULL,
  `p_price` tinyint NOT NULL,
  `p_unit` tinyint NOT NULL,
  `p_status` tinyint NOT NULL,
  `p_logs` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `tbl_purchaseorder_view`
--

DROP TABLE IF EXISTS `tbl_purchaseorder_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_purchaseorder_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_purchaseorder_view` (
  `po_id` tinyint NOT NULL,
  `po_branch` tinyint NOT NULL,
  `po_ref_no` tinyint NOT NULL,
  `po_c_id` tinyint NOT NULL,
  `po_date` tinyint NOT NULL,
  `po_time` tinyint NOT NULL,
  `po_remarks` tinyint NOT NULL,
  `po_status` tinyint NOT NULL,
  `po_log` tinyint NOT NULL,
  `total_amount` tinyint NOT NULL,
  `br_id` tinyint NOT NULL,
  `br_name` tinyint NOT NULL,
  `br_addr` tinyint NOT NULL,
  `br_cnum` tinyint NOT NULL,
  `br_status` tinyint NOT NULL,
  `c_id` tinyint NOT NULL,
  `c_name` tinyint NOT NULL,
  `c_address` tinyint NOT NULL,
  `c_tin` tinyint NOT NULL,
  `c_contact_person` tinyint NOT NULL,
  `c_contact_number` tinyint NOT NULL,
  `c_branch` tinyint NOT NULL,
  `c_type` tinyint NOT NULL,
  `c_status` tinyint NOT NULL,
  `c_logs` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tbl_salesinvoice`
--

DROP TABLE IF EXISTS `tbl_salesinvoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_salesinvoice` (
  `si_id` int(11) NOT NULL AUTO_INCREMENT,
  `si_branch` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `si_ref_no` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `si_c_id` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `si_date` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `si_time` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `si_remarks` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `si_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `si_log` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`si_id`),
  KEY `index_t_date` (`si_date`),
  KEY `index_t_status` (`si_status`),
  KEY `index_t_branch` (`si_branch`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_salesinvoice`
--

LOCK TABLES `tbl_salesinvoice` WRITE;
/*!40000 ALTER TABLE `tbl_salesinvoice` DISABLE KEYS */;
INSERT INTO `tbl_salesinvoice` VALUES (3,'1','10000000','8','2019-12-21','17:17:09',NULL,'Active','Added by: Main Branch-2019-12-21 17:17:09/ Deleted by Main Branch 2019-12-21 17:17:32'),(4,'1','10000001','9','2019-12-01','17:21:24',NULL,'Active','Added by: Main Branch-2019-12-21 17:21:24');
/*!40000 ALTER TABLE `tbl_salesinvoice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_salesinvoice_item`
--

DROP TABLE IF EXISTS `tbl_salesinvoice_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_salesinvoice_item` (
  `sii_id` int(11) NOT NULL AUTO_INCREMENT,
  `sii_ref_no` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sii_p_id` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sii_qty` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sii_price` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sii_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sii_log` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`sii_id`)
) ENGINE=MyISAM AUTO_INCREMENT=993 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_salesinvoice_item`
--

LOCK TABLES `tbl_salesinvoice_item` WRITE;
/*!40000 ALTER TABLE `tbl_salesinvoice_item` DISABLE KEYS */;
INSERT INTO `tbl_salesinvoice_item` VALUES (985,'10000000','000001','10','2','Active','Added by: Main Branch-2019-12-21 17:17:09'),(986,'10000000','000002','20','7','Active','Added by: Main Branch-2019-12-21 17:17:09'),(987,'10000000','000003','30','120','Active','Added by: Main Branch-2019-12-21 17:17:09'),(988,'10000000','000004','40','25','Active','Added by: Main Branch-2019-12-21 17:17:09'),(989,'10000000','000005','50','1200','Active','Added by: Main Branch-2019-12-21 17:17:09'),(990,'10000001','000001','100','2','Active','Added by: Main Branch-2019-12-21 17:21:24'),(991,'10000001','000002','200','7','Active','Added by: Main Branch-2019-12-21 17:21:24'),(992,'10000001','000003','150','120','Active','Added by: Main Branch-2019-12-21 17:21:24/ Updated by Main Branch 2019-12-21 17:25:39/ Updated by Main Branch 2019-12-21 17:26:47/ Updated by Main Branch 2019-12-21 17:27:07/ Updated by Main Branch 2019-12-21 17:27:42/ Updated by Main Branch 2019-12-21 17:28:17/ Deleted by Main Branch 2019-12-21 17:30:50');
/*!40000 ALTER TABLE `tbl_salesinvoice_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `tbl_salesinvoice_item_view`
--

DROP TABLE IF EXISTS `tbl_salesinvoice_item_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_salesinvoice_item_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_salesinvoice_item_view` (
  `sii_id` tinyint NOT NULL,
  `sii_ref_no` tinyint NOT NULL,
  `sii_p_id` tinyint NOT NULL,
  `sii_qty` tinyint NOT NULL,
  `sii_price` tinyint NOT NULL,
  `sii_status` tinyint NOT NULL,
  `sii_log` tinyint NOT NULL,
  `p_id` tinyint NOT NULL,
  `p_code` tinyint NOT NULL,
  `p_name` tinyint NOT NULL,
  `p_category` tinyint NOT NULL,
  `p_quantity` tinyint NOT NULL,
  `p_cost` tinyint NOT NULL,
  `p_price` tinyint NOT NULL,
  `p_unit` tinyint NOT NULL,
  `p_status` tinyint NOT NULL,
  `p_logs` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `tbl_salesinvoice_view`
--

DROP TABLE IF EXISTS `tbl_salesinvoice_view`;
/*!50001 DROP VIEW IF EXISTS `tbl_salesinvoice_view`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE `tbl_salesinvoice_view` (
  `si_id` tinyint NOT NULL,
  `si_branch` tinyint NOT NULL,
  `si_ref_no` tinyint NOT NULL,
  `si_c_id` tinyint NOT NULL,
  `si_date` tinyint NOT NULL,
  `si_time` tinyint NOT NULL,
  `si_remarks` tinyint NOT NULL,
  `si_status` tinyint NOT NULL,
  `si_log` tinyint NOT NULL,
  `total_amount` tinyint NOT NULL,
  `br_id` tinyint NOT NULL,
  `br_name` tinyint NOT NULL,
  `br_addr` tinyint NOT NULL,
  `br_cnum` tinyint NOT NULL,
  `br_status` tinyint NOT NULL,
  `c_id` tinyint NOT NULL,
  `c_name` tinyint NOT NULL,
  `c_address` tinyint NOT NULL,
  `c_tin` tinyint NOT NULL,
  `c_contact_person` tinyint NOT NULL,
  `c_contact_number` tinyint NOT NULL,
  `c_branch` tinyint NOT NULL,
  `c_type` tinyint NOT NULL,
  `c_status` tinyint NOT NULL,
  `c_logs` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Final view structure for view `tbl_client_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_client_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_client_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_client_view` AS select `tbl_client`.`c_id` AS `c_id`,`tbl_client`.`c_name` AS `c_name`,`tbl_client`.`c_address` AS `c_address`,`tbl_client`.`c_tin` AS `c_tin`,`tbl_client`.`c_contact_person` AS `c_contact_person`,`tbl_client`.`c_contact_number` AS `c_contact_number`,`tbl_client`.`c_branch` AS `c_branch`,`tbl_client`.`c_type` AS `c_type`,`tbl_client`.`c_status` AS `c_status`,`tbl_client`.`c_logs` AS `c_logs`,`tbl_branch`.`br_id` AS `br_id`,`tbl_branch`.`br_name` AS `br_name`,`tbl_branch`.`br_addr` AS `br_addr`,`tbl_branch`.`br_cnum` AS `br_cnum`,`tbl_branch`.`br_status` AS `br_status` from (`tbl_client` left join `tbl_branch` on((`tbl_branch`.`br_id` = `tbl_client`.`c_branch`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `tbl_product_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_product_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_product_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_product_view` AS select `tbl_product`.`p_id` AS `p_id`,`tbl_product`.`p_code` AS `p_code`,`tbl_product`.`p_name` AS `p_name`,`tbl_product`.`p_category` AS `p_category`,`tbl_product`.`p_quantity` AS `p_quantity`,`tbl_product`.`p_cost` AS `p_cost`,`tbl_product`.`p_price` AS `p_price`,`tbl_product`.`p_unit` AS `p_unit`,`tbl_product`.`p_status` AS `p_status`,`tbl_product`.`p_logs` AS `p_logs`,(select sum(`tbl_purchaseorder_item`.`poi_qty`) from `tbl_purchaseorder_item` where ((`tbl_purchaseorder_item`.`poi_p_id` = `tbl_product`.`p_id`) and (`tbl_purchaseorder_item`.`poi_status` = 'Active'))) AS `po`,(select sum(`tbl_salesinvoice_item`.`sii_qty`) from `tbl_salesinvoice_item` where ((`tbl_salesinvoice_item`.`sii_p_id` = `tbl_product`.`p_id`) and (`tbl_salesinvoice_item`.`sii_status` = 'Active'))) AS `si` from `tbl_product` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `tbl_purchaseorder_item_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_purchaseorder_item_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_purchaseorder_item_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_purchaseorder_item_view` AS select `tbl_purchaseorder_item`.`poi_id` AS `poi_id`,`tbl_purchaseorder_item`.`poi_ref_no` AS `poi_ref_no`,`tbl_purchaseorder_item`.`poi_p_id` AS `poi_p_id`,`tbl_purchaseorder_item`.`poi_qty` AS `poi_qty`,`tbl_purchaseorder_item`.`poi_cost` AS `poi_cost`,`tbl_purchaseorder_item`.`poi_status` AS `poi_status`,`tbl_purchaseorder_item`.`poi_log` AS `poi_log`,`tbl_product`.`p_id` AS `p_id`,`tbl_product`.`p_code` AS `p_code`,`tbl_product`.`p_name` AS `p_name`,`tbl_product`.`p_category` AS `p_category`,`tbl_product`.`p_quantity` AS `p_quantity`,`tbl_product`.`p_cost` AS `p_cost`,`tbl_product`.`p_price` AS `p_price`,`tbl_product`.`p_unit` AS `p_unit`,`tbl_product`.`p_status` AS `p_status`,`tbl_product`.`p_logs` AS `p_logs` from (`tbl_purchaseorder_item` left join `tbl_product` on((`tbl_product`.`p_id` = `tbl_purchaseorder_item`.`poi_p_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `tbl_purchaseorder_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_purchaseorder_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_purchaseorder_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_purchaseorder_view` AS select `tbl_purchaseorder`.`po_id` AS `po_id`,`tbl_purchaseorder`.`po_branch` AS `po_branch`,`tbl_purchaseorder`.`po_ref_no` AS `po_ref_no`,`tbl_purchaseorder`.`po_c_id` AS `po_c_id`,`tbl_purchaseorder`.`po_date` AS `po_date`,`tbl_purchaseorder`.`po_time` AS `po_time`,`tbl_purchaseorder`.`po_remarks` AS `po_remarks`,`tbl_purchaseorder`.`po_status` AS `po_status`,`tbl_purchaseorder`.`po_log` AS `po_log`,(select sum((`tbl_purchaseorder_item`.`poi_qty` * `tbl_purchaseorder_item`.`poi_cost`)) from `tbl_purchaseorder_item` where ((`tbl_purchaseorder_item`.`poi_ref_no` = `tbl_purchaseorder`.`po_ref_no`) and (`tbl_purchaseorder_item`.`poi_status` = 'Active'))) AS `total_amount`,`tbl_branch`.`br_id` AS `br_id`,`tbl_branch`.`br_name` AS `br_name`,`tbl_branch`.`br_addr` AS `br_addr`,`tbl_branch`.`br_cnum` AS `br_cnum`,`tbl_branch`.`br_status` AS `br_status`,`tbl_client`.`c_id` AS `c_id`,`tbl_client`.`c_name` AS `c_name`,`tbl_client`.`c_address` AS `c_address`,`tbl_client`.`c_tin` AS `c_tin`,`tbl_client`.`c_contact_person` AS `c_contact_person`,`tbl_client`.`c_contact_number` AS `c_contact_number`,`tbl_client`.`c_branch` AS `c_branch`,`tbl_client`.`c_type` AS `c_type`,`tbl_client`.`c_status` AS `c_status`,`tbl_client`.`c_logs` AS `c_logs` from ((`tbl_purchaseorder` left join `tbl_branch` on((`tbl_branch`.`br_id` = `tbl_purchaseorder`.`po_branch`))) left join `tbl_client` on((`tbl_client`.`c_id` = `tbl_purchaseorder`.`po_c_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `tbl_salesinvoice_item_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_salesinvoice_item_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_salesinvoice_item_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_salesinvoice_item_view` AS select `tbl_salesinvoice_item`.`sii_id` AS `sii_id`,`tbl_salesinvoice_item`.`sii_ref_no` AS `sii_ref_no`,`tbl_salesinvoice_item`.`sii_p_id` AS `sii_p_id`,`tbl_salesinvoice_item`.`sii_qty` AS `sii_qty`,`tbl_salesinvoice_item`.`sii_price` AS `sii_price`,`tbl_salesinvoice_item`.`sii_status` AS `sii_status`,`tbl_salesinvoice_item`.`sii_log` AS `sii_log`,`tbl_product`.`p_id` AS `p_id`,`tbl_product`.`p_code` AS `p_code`,`tbl_product`.`p_name` AS `p_name`,`tbl_product`.`p_category` AS `p_category`,`tbl_product`.`p_quantity` AS `p_quantity`,`tbl_product`.`p_cost` AS `p_cost`,`tbl_product`.`p_price` AS `p_price`,`tbl_product`.`p_unit` AS `p_unit`,`tbl_product`.`p_status` AS `p_status`,`tbl_product`.`p_logs` AS `p_logs` from (`tbl_salesinvoice_item` left join `tbl_product` on((`tbl_product`.`p_id` = `tbl_salesinvoice_item`.`sii_p_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `tbl_salesinvoice_view`
--

/*!50001 DROP TABLE IF EXISTS `tbl_salesinvoice_view`*/;
/*!50001 DROP VIEW IF EXISTS `tbl_salesinvoice_view`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 VIEW `tbl_salesinvoice_view` AS select `tbl_salesinvoice`.`si_id` AS `si_id`,`tbl_salesinvoice`.`si_branch` AS `si_branch`,`tbl_salesinvoice`.`si_ref_no` AS `si_ref_no`,`tbl_salesinvoice`.`si_c_id` AS `si_c_id`,`tbl_salesinvoice`.`si_date` AS `si_date`,`tbl_salesinvoice`.`si_time` AS `si_time`,`tbl_salesinvoice`.`si_remarks` AS `si_remarks`,`tbl_salesinvoice`.`si_status` AS `si_status`,`tbl_salesinvoice`.`si_log` AS `si_log`,(select sum((`tbl_salesinvoice_item`.`sii_qty` * `tbl_salesinvoice_item`.`sii_price`)) from `tbl_salesinvoice_item` where ((`tbl_salesinvoice_item`.`sii_ref_no` = `tbl_salesinvoice`.`si_ref_no`) and (`tbl_salesinvoice_item`.`sii_status` = 'Active'))) AS `total_amount`,`tbl_branch`.`br_id` AS `br_id`,`tbl_branch`.`br_name` AS `br_name`,`tbl_branch`.`br_addr` AS `br_addr`,`tbl_branch`.`br_cnum` AS `br_cnum`,`tbl_branch`.`br_status` AS `br_status`,`tbl_client`.`c_id` AS `c_id`,`tbl_client`.`c_name` AS `c_name`,`tbl_client`.`c_address` AS `c_address`,`tbl_client`.`c_tin` AS `c_tin`,`tbl_client`.`c_contact_person` AS `c_contact_person`,`tbl_client`.`c_contact_number` AS `c_contact_number`,`tbl_client`.`c_branch` AS `c_branch`,`tbl_client`.`c_type` AS `c_type`,`tbl_client`.`c_status` AS `c_status`,`tbl_client`.`c_logs` AS `c_logs` from ((`tbl_salesinvoice` left join `tbl_branch` on((`tbl_branch`.`br_id` = `tbl_salesinvoice`.`si_branch`))) left join `tbl_client` on((`tbl_client`.`c_id` = `tbl_salesinvoice`.`si_c_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-12-21 17:40:32
